<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Match Form</title>
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #89f7fe, #66a6ff);
        }

        .form-container {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
        }

        h2 {
            text-align: center;
            margin-bottom: 1rem;
            color: #333;
        }

        .form-group {
            margin-bottom: 1rem;
        }

        label {
            display: block;
            margin-bottom: 0.5rem;
            color: #555;
        }

        input[type="password"] {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 1rem;
            box-sizing: border-box;
        }

        #submit {
            display: none;
            width: 100%;
            padding: 0.75rem;
            border: none;
            border-radius: 5px;
            background-color: #4caf50;
            color: white;
            font-size: 1rem;
            cursor: pointer;
        }

        #submit:hover {
            background-color: #45a049;
        }

        .error-message {
            color: red;
            font-size: 0.9rem;
            display: none;
            margin-top: -0.5rem;
            margin-bottom: 1rem;
        }

        @media (max-width: 600px) {
            .form-container {
                padding: 1.5rem;
            }

            input[type="password"], #submit {
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
    <div class="form-container">
        <h2>Password Validation Form</h2>
        <form id="passwordForm" method="post">
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <label for="confirmPassword">Confirm Password</label>
                <input type="password" id="confirmPassword" name="confirmPassword" required>
                <div class="error-message" id="errorMessage">Passwords do not match!</div>
            </div>
            <button type="submit" id="submit">Submit</button>
        </form>
    </div>

    <script>
        const password = document.getElementById('password');
        const confirmPassword = document.getElementById('confirmPassword');
        const submitButton = document.getElementById('submit');
        const errorMessage = document.getElementById('errorMessage');

        function validatePasswords() {
            if (password.value === confirmPassword.value && password.value !== '') {
                submitButton.style.display = 'block';
                errorMessage.style.display = 'none';
            } else {
                submitButton.style.display = 'none';
                if (confirmPassword.value !== '') {
                    errorMessage.style.display = 'block';
                } else {
                    errorMessage.style.display = 'none';
                }
            }
        }

        password.addEventListener('input', validatePasswords);
        confirmPassword.addEventListener('input', validatePasswords);

        // Prevent form submission for demo purposes
        // document.getElementById('passwordForm').addEventListener('submit', function(e) {
        //     e.preventDefault();
        //     alert('Form submitted successfully!');
        // });
    </script>
</body>
</html>
