<div class="container-fluid">
  <!--  Row 1 -->

  <div class="row">

    <div class="col-lg-12 d-flex align-items-stretch">
      <div class="card w-100">
        <div class="card-body p-4">
          <h2 class="  mb-4">Users</h2>
          <div class="table-responsive">
            <table id="example" class="table text-nowrap mb-0 align-middle">
              <thead class="text-dark fs-4">
                <tr>
                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Id</h6>
                  </th>

                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Name</h6>
                  </th>

                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Email</h6>
                  </th>
                  
                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Wallet</h6>
                  </th>
                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">User Type</h6>
                  </th>
                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Action</h6>
                  </th>

                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
 


  <!-- Coins Assignment Modal -->
<div class="modal fade" id="assignCoinsModal" tabindex="-1" aria-labelledby="assignCoinsModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="assignCoinsModalLabel">Assign Coins to User</h5>
        <button type="button" class="btn btn-danger border close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true"><i class="fa-solid fa-xmark"></i></span>
        </button>
      </div>
      <div class="modal-body">
        <form id="assignCoinsForm">
          <div class="form-group">
            <label for="coinsAmount">Number of Coins</label>
            <input type="number" class="form-control" id="coinsAmount" name="coinsAmount" required>
            <input type="hidden" id="userId" name="userId">
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-light btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary btn-sm" onclick="assignCoins()">Assign Coins</button>
      </div>
    </div>
  </div>
</div>


<script>
  $(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
  });


  var datatable = $('#example').DataTable({
    ajax: {
      url: '<?= site_url() ?>/admin-get-users-list',
      type: 'POST',
      data: function(d) {
        // d.order = [{
        //   column: 0, // Specify the column index for sorting (0 represents the first column)
        //   dir: 'desc' // Set the sorting direction to 'desc' for descending order
        // }];
      },
    },
    columns: [
        { data: 0 }, // ID
        { data: 1 }, // Name
        { data: 2 }, // Email
        { data: 3 }, // Wallet
        { data: 4 }, // User Type
        { data: 5 }  // Actions
    ],
    order: [[0, 'desc']],
    pageLength: 25, // Show 50 records by default
    lengthMenu: [ [25,50, 100, 150, 200, 250], [25,50, 100, 150, 200, 250] ],
    processing: true,
    serverSide: true,
    // stateSave: true
  });



  function change_user_type(user_id,type){
    if (confirm("Are you sure you want to change the user type?")) {
      $.ajax({
        url: "<?= site_url(); ?>/admin/users/change_user_type",
        method: 'POST',
        data:{
          'user_id': user_id,
          'type': type
        },
        dataType:'json',
        success: function(response){
            success(response.message);
            setTimeout(function(){
                datatable.ajax.reload();
            }, 1000);
            
        },error: function(error){
            error(response.message);
        }
      });
    }
  }


   // Function to open the assign coins modal
   window.openAssignCoinsModal = function(userId) {
    $('#userId').val(userId); // Set user ID in hidden input
    $('#assignCoinsModal').modal('show'); // Show the modal
  };

  // Function to assign coins to user
  window.assignCoins = function() {
    var userId = $('#userId').val();
    var coinsAmount = $('#coinsAmount').val();

    if (coinsAmount <= 0) {
      alert("Please enter a valid number of coins.");
      return;
    }

    $.ajax({
      url: "<?= site_url(); ?>/admin/users/assign_coins",
      method: 'POST',
      data: {
        'user_id': userId,
        'coins': coinsAmount
      },
      dataType: 'json',
      success: function(response) {

        console.log(response);

        $('#assignCoinsModal').modal('hide'); // Hide the modal
        success(response.message);
        setTimeout(function() {
          datatable.ajax.reload(null, false); // Reload without resetting pagination
        }, 1000);
      },
      error: function() {
        error("An error occurred. Please try again.");
      }
    });
  };


  function deleteUser(userId) {
    if (confirm("Are you sure you want to delete this user? This action is irreversible.")) {
      $.ajax({
        url: "<?= site_url(); ?>/admin/users/delete_user",
        method: "POST",
        data: { user_id: userId },
        dataType: "json",
        success: function(response) {
          if (response.status === "success") {
            success(response.message);
            datatable.ajax.reload(null, false);
          } else {
            error(response.message);
          }
        },
        error: function() {
          error("Something went wrong while deleting the user.");
        }
      });
    }
  }


</script>