
<div class="container-fluid ">
    <div class="row">
        <div class="col-lg-12 d-flex align-items-stretch">
            <div class="card w-100">
                <div class="card-body p-4">
                    <h2 class="mb-4">Spin Wheel </h2>

                    <div class="table-responsive mt-3">
                        <table class="table text-nowrap">
                            <thead class="text-dark fs-4">
                                <tr>
                                    <th>Min</th>
                                    <th>Max</th>
                                    <th>Amount (to get a spin)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr id="spin-row" class="editable-row">
                                    <td>
                                        <input type="number" id="min" value="<?= $spin['min']; ?>" class="form-control form-control-sm" style="display:none;">
                                        <span id="min-display"><?= $spin['min']; ?></span>
                                    </td>
                                    <td>
                                        <input type="number" id="max" value="<?= $spin['max']; ?>" class="form-control form-control-sm" style="display:none;">
                                        <span id="max-display"><?= $spin['max']; ?></span>
                                    </td>
                                    <td>
                                        <input type="number" id="amount" value="<?= $spin['amount']; ?>" class="form-control form-control-sm" style="display:none;">
                                        <span id="amount-display"><?= $spin['amount']; ?></span>
                                    </td>
                                    <td>
                                        <div id="action-buttons" class="d-flex align-items-center gap-3">
                                            <a href="#" class="btn btn-warning btn-sm edit-btn" data-toggle="tooltip" data-placement="top" title="Edit">
                                                <i class="fas fa-edit fa-lg"></i>
                                            </a>
                                            <button type="button" class="btn btn-success btn-sm save-btn" style="display:none;">
                                                <i class="fa-solid fa-check"></i>
                                            </button>
                                            <button type="button" class="btn btn-secondary btn-sm cancel-btn" style="display:none;">
                                                <i class="fa-solid fa-xmark"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


<script>
$(document).ready(function() {
    function enableEditMode() {
        $("#min, #max, #amount").show();
        $("#min-display, #max-display, #amount-display").hide();
        $(".edit-btn").hide();
        $(".save-btn, .cancel-btn").show();
    }

    function disableEditMode(newMin, newMax, newamount) {
        $("#min, #max, #amount").hide();
        $("#min-display").text(newMin).show();
        $("#max-display").text(newMax).show();
        $("#amount-display").text(newamount).show();
        $(".edit-btn").show();
        $(".save-btn, .cancel-btn").hide();
    }

    $(".edit-btn").on("click", function(e) {
        e.preventDefault();
        enableEditMode();
    });

    $(".cancel-btn").on("click", function() {
        location.reload(); // Reload page to reset changes
    });

    $(".save-btn").on("click", function() {
        if (confirm('Do you want to save changes?')) {
            const newMin = $("#min").val();
            const newMax = $("#max").val();
            const newamount = $("#amount").val();

            $.ajax({
                url: "<?= site_url('admin/SpinWheel/update_spin'); ?>",
                method: 'POST',
                data: { min: newMin, max: newMax, amount: newamount },
                dataType: 'JSON',
                success: function(response) {
                    if (response.status) {
                        disableEditMode(newMin, newMax, newamount);
                    }
                }
            });
        }
    });
});
</script>