<div class="container-fluid">
  <!--  Row 1 -->

  <div class="row">

    <div class="col-lg-12 d-flex align-items-stretch">
      <div class="card w-100">
        <div class="card-body p-4">

    <h2>Edit Ad</h2>
    <form method="POST" enctype="multipart/form-data">
        <div class="row">

            <div class="col-md-6">
                
                <div class="mb-3">
                    <label>Current Thumbnail</label><br>
                    <img src="<?= $details['thumbnail'] ?>" alt="Thumbnail" style="max-width: 150px;">
                </div>
        
                <div class="mb-3">
                    <label>Change Thumbnail</label>
                    <input type="file" name="thumbnail" accept="image/*" class="form-control">
                </div>
            </div>
    
            <div class="col-md-6">

                <div class="mb-3">
                    <label>Current Media</label><br>
                    <?php if ($details['type'] == '1'): ?>
                        <img src="<?= $details['file'] ?>" alt="Media" style="max-width: 300px;">
                    <?php else: ?>
                        <video controls style="max-width:300px;">
                            <source src="<?= $details['file'] ?>" type="video/mp4">
                        </video>
                    <?php endif; ?>
                </div>
        
                <div class="mb-3">
                    <label>Change Media</label>
                    <input type="file" name="file" accept="video/*,image/*" class="form-control">
                </div>
        
            </div>

            <div class="mb-3 col-md-12">
                <label>Title</label>
                <input type="text" name="title" value="<?= htmlspecialchars($details['title']) ?>" class="form-control" required>
            </div>
    
            <div class="mb-3 col-md-6">
                <label>URL</label>
                <input type="url" name="url" value="<?= htmlspecialchars($details['url']) ?>" class="form-control" required>
            </div>
    
            <div class="mb-3 col-md-6">
                <label>Target Audience</label>
                <input type="number" name="target" value="<?= htmlspecialchars($details['target']) ?>" class="form-control" required>
            </div>
    
            <div class="mb-3 col-md-6">
                <label>Priority</label>
                <select name="occurance" class="form-control" required>
                    <option value="1" <?= $details['occurance'] == 1 ? 'selected' : '' ?>>Low</option>
                    <option value="2" <?= $details['occurance'] == 2 ? 'selected' : '' ?>>Medium</option>
                    <option value="3" <?= $details['occurance'] == 3 ? 'selected' : '' ?>>High</option>
                </select>
            </div>
    
            <div class="mb-3 col-md-6">
                <label>Watch Credit</label>
                <input type="number" name="watch_credit" value="<?= htmlspecialchars($details['watch_credit']) ?>" class="form-control" required>
            </div>
    
            <div class="mb-3 col-md-6">
                <label>Running Date From</label>
                <input type="date" name="date_from" value="<?= htmlspecialchars($details['date_from']) ?>" class="form-control" required>
            </div>
    
            <div class="mb-3 col-md-6">
                <label>Running Date To</label>
                <input type="date" name="date_to" value="<?= htmlspecialchars($details['date_to']) ?>" class="form-control" required>
            </div>
        </div>

        <button type="submit" class="btn btn-primary btn-sm">Update Ad</button>
        <a href="<?= site_url('/admin/ads') ?>" class="btn btn-secondary btn-sm">Cancel</a>
    </form>
</div>

</div>
</div>
</div>
</div>
