<div class="container-fluid">
  <div class="container-fluid">
    <div class="card">
      <div class="card-body">
        <h5 class="card-title fw-semibold mb-4">Create Credits</h5>
        <div class="card">
          <div class="card-body">
            <form method="POST" >

                <div class="mb-3">
                    <label for="credits" class="form-label">Credits</label>
                    <input name="credits" required type="text" class="form-control" id="credits" min="1">
                </div>

                <div class="mb-3">
                    <label for="og_price" class="form-label">Original Price</label>
                    <input type="text" name="og_price" required class="form-control" id="og_price" min="1" oninput="updatePrice()">
                </div>

                <div class="mb-3">
                    <label for="discount" class="form-label">Discount %</label>
                    <input type="text" name="discount" required class="form-control" id="discount" min="1" oninput="updatePrice()">
                </div>

                <div class="mb-3">
                    <label for="price" class="form-label">Price (with discount)</label>
                    <input type="text" name="price" required class="form-control" id="price" min="1" readonly>
                </div>

                <button type="submit" class="btn btn-primary btn-sm">Submit</button>
                
            </form>
          </div>
        </div>

 
    </div>
  </div>
</div>



<script>
function updatePrice() {
    // Get the original price and discount percentage
    var og_price = parseFloat(document.getElementById('og_price').value);
    var discount = parseFloat(document.getElementById('discount').value);
    
    // Calculate the price after discount
    var price = og_price - (og_price * discount / 100);
    
    // Update the price field
    document.getElementById('price').value = price.toFixed(2);
}
</script>
