<?php

defined('BASEPATH') or exit('direct script access not allowed');

class Requestmodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }


    public function get_pending_requests($service_id, $current_user_id) {
        $this->db->select('
                usr.id AS request_id, 
                usr.user_id, 
                usr.link, 
                usr.target, 
                usr.buffered_count, 
                usr.remaining_count, 
                s.id AS service_id, 
                s.name AS service_name, 
                s.reward_coins,
                usr.created_at as created_at'
            );
        $this->db->from('user_service_requests usr');
        $this->db->join('services s', 'usr.service_id = s.id');
        $this->db->where('usr.remaining_count >', 0); // Only requests with remaining actions
        $this->db->where('usr.remaining_count <= usr.buffered_count'); // Ensure actions are within buffer
        $this->db->where('usr.service_id', $service_id); // Match the service_id
        $this->db->where('usr.user_id !=', $current_user_id); // Exclude current user's requests
        $query = $this->db->get();
    
        return $query->result_array(); // Return as an array of results
    }

    // updated as per admin 

    public function get_pending_requests1($service_id, $current_user_id, $type, $coin_setting) {
        $service = $this->db->get_where('services', ['id' => 15])->row_array();
        $coins_settings = $this->db->get_where('coins_rewards_settings', ['type' => $coin_setting])->row_array();

        $this->db->select("
            admin_videos.id AS request_id,
            $current_user_id AS user_id,
            admin_videos.link,
            admin_videos.thumbnail,
            admin_videos.target,
            admin_videos.buffered_count,
            admin_videos.remaining_count,
            '{$service['id']}' AS service_id,
            '{$service['name']}' AS service_name,
            '{$coins_settings['coins']}' AS reward_coins,
            admin_videos.created_at
        ");
        $this->db->from('admin_videos');
        $this->db->where('admin_videos.remaining_count >', 0); // Only requests with remaining actions
        $this->db->where('admin_videos.remaining_count <= admin_videos.buffered_count'); 
        $this->db->where('admin_videos.type', $type); // view
        $this->db->where('admin_videos.remove', '0');
        $query = $this->db->get();
        return $query->result_array(); // Return the result
    }
    
    public function get_pending_requests2($service_id, $current_user_id, $type, $coin_setting) {
        // Step 1: Get video IDs the user has already interacted with (e.g., liked)
        $this->db->select('admin_video_id');
        $this->db->from('admin_videos_history');
        $this->db->where('user_id', $current_user_id);
        $this->db->where('type', $type);
        $already_done = $this->db->get()->result_array();
    
        $exclude_ids = array_column($already_done, 'admin_video_id');

        // Step 2: Get service and reward details
        $service = $this->db->get_where('services', ['id' => $service_id])->row_array();
        $coins_settings = $this->db->get_where('coins_rewards_settings', ['type' => $coin_setting])->row_array();
    
        // Step 3: Fetch admin_videos not already done
        $this->db->select("
            admin_videos.id AS request_id,
            $current_user_id AS user_id,
            admin_videos.link,
            admin_videos.thumbnail,
            admin_videos.target,
            admin_videos.buffered_count,
            admin_videos.remaining_count,
            '{$service['id']}' AS service_id,
            '{$service['name']}' AS service_name,
            '{$coins_settings['coins']}' AS reward_coins,
            admin_videos.created_at
        ");
        $this->db->from('admin_videos');
        $this->db->where('admin_videos.remaining_count >', 0); // Only requests with remaining actions
        $this->db->where('admin_videos.remaining_count <= admin_videos.buffered_count'); 
        $this->db->where('admin_videos.type', $type); // view
        $this->db->where('admin_videos.remove', '0');

        // Exclude already interacted video IDs
        if (!empty($exclude_ids)) {
            $this->db->where_not_in('admin_videos.id', $exclude_ids);
        }

        $query = $this->db->get();
        return $query->result_array(); // Return the result
    }
    
    

    public function get_all_pending_requests($current_user_id) {
        $this->db->select('
                usr.id AS request_id, 
                usr.user_id, 
                usr.link, 
                usr.target, 
                usr.buffered_count, 
                usr.remaining_count, 
                s.id AS service_id, 
                s.name AS service_name, 
                s.reward_coins,
                usr.created_at as created_at
        ');
        $this->db->from('user_service_requests usr');
        $this->db->join('services s', 'usr.service_id = s.id');
        $this->db->where('usr.remaining_count >', 0); // Only requests with remaining actions
        $this->db->where('usr.remaining_count <= usr.buffered_count'); // Ensure actions are within buffer
        $this->db->where('usr.user_id !=', $current_user_id); // Exclude current user's requests
        $this->db->order_by('usr.created_at', 'DESC'); // Optional: Sort by most recent requests
        $query = $this->db->get();

        return $query->result_array(); // Return as an array of results
    }
    

    public function update_request_progress($request_id) {
        $this->db->set('remaining_count', 'remaining_count - 1', FALSE);
        $this->db->set('completed_count', 'completed_count + 1', FALSE);
        $this->db->where('id', $request_id);
        $this->db->update('admin_videos');
        // $this->db->update('user_service_requests');
    }
    

    public function mark_as_completed($request_id) {
        $this->db->set('status', 'completed');
        $this->db->where('id', $request_id);
        $this->db->update('user_service_requests');
    }
    

    public function log_action($user_id, $request_id, $service_name, $reward_coins) {
        $data = [
            'user_id' => $user_id,
            'request_id' => $request_id,
            'action_type' => $service_name,
            'reward_coins' => $reward_coins,
            'executed_at' => date('Y-m-d H:i:s')
        ];
        $this->db->insert('action_logs', $data);
    }
    

    public function get_requests_by_user($user_id, $limit, $offset, $status = null) {
        $this->db->select('
            id, 
            service_id, 
            link, 
            target, 
            buffered_count, 
            completed_count, 
            remaining_count, 
            status, 
            total_charges, 
            created_at
        ');
        $this->db->from('user_service_requests');
        $this->db->where('user_id', $user_id);

        // Optional filter for status
        if (!empty($status)) {
            $this->db->where('status', $status);
        }

        $this->db->order_by('created_at', 'DESC'); // Sort by the latest
        $this->db->limit($limit, $offset);

        $query = $this->db->get();
        return $query->result_array();
    }

}