<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require_once APPPATH . "core/My_Admin.php";

class SpinWheel extends My_Admin {

    public function __construct() {
        parent::__construct();
    }

    // Show the spin wheel settings
    public function index() {
        $data['spin'] = $this->db->get('spin_wheel')->row_array();

        // print_r($data);exit;

        $this->load->view('admin/includes/header', $data);
        $this->load->view('admin/spin_wheel/view', $data);
        $this->load->view('admin/includes/footer');
    }

    // AJAX Update method
    public function update_spin() {
        if ($this->input->post()) {
            $updateData = [
                'min' => $this->input->post('min'),
                'max' => $this->input->post('max'),
                'amount' => $this->input->post('amount')
            ];

            // Perform the update
            $this->db->update('spin_wheel', $updateData);

            // Return success response
            echo json_encode(['status' => true, 'message' => 'Spin Wheel settings updated successfully']);
            return;
        }

        // Return error response
        echo json_encode(['status' => false, 'message' => 'Invalid request']);
    }
}
