<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require_once APPPATH . "core/My_Admin.php";

class Notification extends My_Admin{
    public function __construct(){
        parent::__construct();

    }


    // ? --------------------- push notification ---------------------
    
    public function index(){

        $data['title'] = 'Ichi || Push Notification';
        $data['heading'] = 'Push Notification';
        $data['active'] = 'push_notification';

        $this->load->view('admin/includes/header', $data);
        $this->load->view('admin/push_notification/notification_create');
        $this->load->view('admin/includes/footer');
    }


    // * send nnotification to all users
    public function send_notification() {
        try {
            // Retrieve the POST data
            $title = $this->input->post('title');
            $message = $this->input->post('message');
    
            // Validate inputs
            if (empty($title) || empty($message)) {
                $response = [
                    'status' => '0',
                    'message' => 'Title and message are required.'
                ];
                echo json_encode($response);
                return;
            }
    
    
            // Get all users
            $users = $this->db->get('users')->result_array();
    
            // Extract regIds from users
            $regIds = [];
            foreach ($users as $user) {
                if (!empty($user['regId'])) {
                    $regIds[] = $user['regId'];
                }
            }

            // Check if regIds are available
            if (empty($regIds)) {
                $response = [
                    'status' => '0',
                    'message' => 'No valid registration IDs found to send notifications.'
                ];
                echo json_encode($response);
                return;
            }
    
            // Load the FCM helper
            $this->load->helper('fcm_helper');
    
            // Chunk the regIds to comply with FCM's 500 tokens per request limit
            $chunks = array_chunk($regIds, 500);
    
            // Send notifications for each chunk
            $responses = [];
            foreach ($chunks as $chunk) {
                $response = send_fcm_notification($chunk, $title, $message);
                $responses[] = $response;
            }
    
            // Return a success response
            $response = [
                'status' => '1',
                'message' => 'Notifications sent successfully.',
                'responses' => $responses
            ];
            echo json_encode($response);
    
        } catch (Exception $e) {
            // Log the exception
            log_message('error', 'Exception in send_notification: ' . $e->getMessage());
    
            // Return an error response
            $response = [
                'status' => '0',
                'message' => 'Failed to send notifications. ' . $e->getMessage()
            ];
            echo json_encode($response);
        }
    }
    
    

}