var useEdge = false
var useDebug = false
var closeOnClick = true
var notify = document.querySelector('#notify')

function error(message) {

    nativeToast(
        message,
        'error'
    )
}

function info(message) {

    nativeToast(
        message,
        'info'
    )
}

function warning(message) {

    nativeToast(
        message,
        'warning'
    )
}

function success(message) {
    nativeToast(
        message,
        'success'
    )
}

const icons = {
    warning: `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12" y2="16"></line></svg>`,
    success: `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-circle"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>`,
    info: `<svg viewBox="0 0 32 32" width="32" height="32" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="6.25%"><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx="16" cy="16" r="14" /></svg>`,
    error: `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-triangle"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12" y2="17"></line></svg>`
}




function nativeToast(message, type) {



    var toast = document.createElement('div')
    toast.className = 'native-toast '
    toast.className += 'native-toast-' + type
    var messageBody = '<span class="native-toast-icon-' + type + '">' + icons[type] + ' </span>' + '<span style="text-transform: capitalize;"> ' + message + '</span>'

    const messageElement = document.createElement('div')
    messageElement.className = 'native-toast-message'
    messageElement.innerHTML = messageBody

    toast.appendChild(messageElement)

    const isMobile = document.body.clientWidth < 768
    if (isMobile) {
        toast.className += ' native-toast-edge'
    } else {
        toast.style.borderRadius = '33px'
    }

    notify.appendChild(toast)


    setTimeout(() => {
        toast.classList.add('native-toast-shown')
    }, 300)


    setTimeout(() => {
        destroy()
    }, 3000)


    function destroy() {
        toast.classList.remove('native-toast-shown')

    }



}