<div class="container-fluid">
    <!--  Row 1 -->
    <div class="row">
        <div class="col-lg-12 d-flex align-items-stretch">
            <div class="card w-100">
                <div class="card-body p-4">

                <div class="d-flex justify-content-between">
                    <h2 class="mb-4">Discount</h2>
                    <a href="<?= site_url('/admin/discount/create') ?>"><button type="button" class="btn btn-primary">Create+</button></a> 
                </div>
                    <div class="table-responsive mt-3">
                        <table class="table text-nowrap">
                            <thead class="text-dark fs-4">
                                <tr>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-bold fs-5 mb-0">Sr no</h6>
                                    </th>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-bold fs-5 mb-0">User Count</h6>
                                    </th>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-bold fs-5 mb-0">Discount</h6>
                                    </th>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-bold fs-5 mb-0">Action</h6>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; foreach($details as $data){ ?>
                                <tr id="row-<?php echo $data['id']; ?>" class="editable-row">
                                    <td class="border-bottom-0">
                                        <h6 class="fw-normal mb-0"><?= $i; ?></h6>
                                    </td>
                                    <td class="border-bottom-0">
                                        <input type="text" id="user-count-<?php echo $data['id']; ?>" value="<?= $data['min_quantity']; ?>" class="form-control form-control-sm" style="display:none;">
                                        <span id="user-count-display-<?php echo $data['id']; ?>"><?= $data['min_quantity']; ?></span>
                                    </td>
                                    <td class="border-bottom-0">
                                        <input type="text" id="discount-<?php echo $data['id']; ?>" value="<?= $data['discount_percentage']; ?>" class="form-control form-control-sm" style="display:none;">
                                        <span id="discount-display-<?php echo $data['id']; ?>"><?= $data['discount_percentage']; ?></span>
                                    </td>
                                    <td class="border-bottom-0">
                                        <div id="action-buttons-<?php echo $data['id']; ?>" class="d-flex align-items-center gap-3">
                                            <a href="#" class="btn btn-sm btn-warning edit-btn" data-id="<?php echo $data['id']; ?>" data-toggle="tooltip" data-placement="top" title="Edit">
                                                <i class="fa-solid fa-pen-to-square"></i>
                                            </a>
                                            <button type="button" class="btn btn-success btn-sm save-btn" data-id="<?php echo $data['id']; ?>" style="display:none;"><i class="fa-solid fa-check"></i></button>
                                            <button type="button" class="btn btn-secondary btn-sm cancel-btn" data-id="<?php echo $data['id']; ?>" style="display:none;"><i class="fa-solid fa-xmark"></i></button>
                                            <button type="button" class="btn btn-sm btn-danger  delete-btn" data-id="<?php echo $data['id']; ?>">
                                                <i class="fa-solid fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php $i++; } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        let currentEditRowId = null; // Keeps track of the currently editable row

        function disableEditMode(rowId, newUserCount, newDiscount) {
            document.getElementById(`user-count-${rowId}`).style.display = 'none';
            document.getElementById(`discount-${rowId}`).style.display = 'none';
            document.getElementById(`user-count-display-${rowId}`).textContent = newUserCount;
            document.getElementById(`discount-display-${rowId}`).textContent = newDiscount;
            document.getElementById(`user-count-display-${rowId}`).style.display = 'inline';
            document.getElementById(`discount-display-${rowId}`).style.display = 'inline';
            document.querySelector(`#action-buttons-${rowId} .edit-btn`).style.display = 'inline-block';
            document.querySelector(`#action-buttons-${rowId} .save-btn`).style.display = 'none';
            document.querySelector(`#action-buttons-${rowId} .cancel-btn`).style.display = 'none';
        }

        function enableEditMode(rowId) {
            if (currentEditRowId && currentEditRowId !== rowId) {
                const currentId = currentEditRowId;
                const userCount = document.getElementById(`user-count-display-${currentId}`).textContent;
                const discount = document.getElementById(`discount-display-${currentId}`).textContent;
                disableEditMode(currentId, userCount, discount);
            }

            document.getElementById(`user-count-${rowId}`).style.display = 'block';
            document.getElementById(`discount-${rowId}`).style.display = 'block';
            document.getElementById(`user-count-display-${rowId}`).style.display = 'none';
            document.getElementById(`discount-display-${rowId}`).style.display = 'none';
            document.querySelector(`#action-buttons-${rowId} .edit-btn`).style.display = 'none';
            document.querySelector(`#action-buttons-${rowId} .save-btn`).style.display = 'inline-block';
            document.querySelector(`#action-buttons-${rowId} .cancel-btn`).style.display = 'inline-block';

            currentEditRowId = rowId;
        }

        document.querySelectorAll('.edit-btn').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const id = this.getAttribute('data-id');
                enableEditMode(id);
            });
        });

        document.querySelectorAll('.cancel-btn').forEach(button => {
            button.addEventListener('click', function() {
                const id = this.getAttribute('data-id');
                const userCount = document.getElementById(`user-count-display-${id}`).textContent;
                const discount = document.getElementById(`discount-display-${id}`).textContent;
                disableEditMode(id, userCount, discount);
                currentEditRowId = null; // Reset the current editable row
            });
        });

        document.querySelectorAll('.save-btn').forEach(button => {
            button.addEventListener('click', function() {
                if(confirm('Do you want to save changes')) {
                    const id = this.getAttribute('data-id');
                    const newUserCount = document.getElementById(`user-count-${id}`).value;
                    const newDiscount = document.getElementById(`discount-${id}`).value;

                    $.ajax({
                        url: "<?= site_url(); ?>/admin/discount/update_discount?discount_id=" + id,
                        method: 'POST',
                        data: {
                            min_quantity: newUserCount,
                            discount_percentage: newDiscount
                        },
                        dataType: 'JSON',
                        success: function(response) {
                            if(response.status) {
                                disableEditMode(id, newUserCount, newDiscount);
                                currentEditRowId = null; // Reset the current editable row

                                success(response.message);
                                setTimeout(function(){
                                    location.reload();
                                }, 1000);
                            }
                        },
                        error: function(error) {
                            // Handle error
                        }
                    });
                }
            });
        });


        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function() {
                if(confirm('Are you sure you want to delete this discount?')) {
                    const id = this.getAttribute('data-id');

                    $.ajax({
                        url: "<?= site_url(); ?>/admin/discount/delete_discount?discount_id=" + id,
                        method: 'POST',
                        dataType: 'JSON',
                        success: function(response) {
                            if(response.status) {
                                document.getElementById(`row-${id}`).remove();
                                success(response.message);
                            }
                        },
                        error: function(error) {
                            // Handle error
                        }
                    });
                }
            });
        });


    });
</script>
