<?php

defined('BASEPATH') or exit('direct script access not allowed');

class Storemodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    protected $table = 'store';

    var $order = array('id', 'credits', 'price', 'discount');

    private function _get_data_query($where)
    {
        $this->db->select("$this->table.*");
        $this->db->from($this->table);

        if (isset($_POST['search']['value'])) {
            $searchTerm = $_POST['search']['value'];
            $this->db->group_start();
            $this->db->like('' . $this->table . '.credits', $searchTerm);
            $this->db->or_like('' . $this->table . '.price', $searchTerm);
            $this->db->or_like('' . $this->table . '.discount', $searchTerm);
            $this->db->group_end();
        }
        
        $this->db->where($where);
        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {

            $this->db->order_by('id', 'desc');
        }
    }

    public function get_data_table($where)
    {
        // print_r($where);exit;
        $this->_get_data_query($where);
        if ($_POST['length'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }

        $query = $this->db->get();
        // $b = $query->result_array();
        // print_r($this->db->last_query());
        // exit;
        return $query->result_array();
    }

    public function count_filtered_data($where)
    {
        $this->_get_data_query($where);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_data($where)
    {
        $this->db->from($this->table);
        $this->db->where($where);
        return $this->db->count_all_results();
    }

}
