<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require_once APPPATH . "core/My_Admin.php";

class Sitemap extends My_Admin {

    public function __construct() {
        parent::__construct();
    }

    public function index() {
        // $data['sitemap_links'] = [
        //     ['url' => site_url('/admin/dashboard'), 'name' => 'Dashboard'],
        //     ['url' => site_url('/admin/users'), 'name' => 'Users'],
        //     ['url' => site_url('/admin/ads'), 'name' => 'Ads'],
        //     ['url' => site_url('/admin/services'), 'name' => 'Services'],
        //     ['url' => site_url('/admin/store'), 'name' => 'Store'],
        //     ['url' => site_url('/admin/help'), 'name' => 'Help Center'],
        //     ['url' => site_url('/admin/policy'), 'name' => 'Privacy Policy'],
        //     ['url' => site_url('/admin/notification'), 'name' => 'Push Notifications'],
        //     ['url' => site_url('/admin/versions'), 'name' => 'App Version'],
        //     ['url' => site_url('/admin/SpinWheel'), 'name' => 'Spin Wheel'],
        //     ['url' => site_url('/admin/rewards'), 'name' => 'Rewards'],
        //     ['url' => site_url('/admin/discount'), 'name' => 'Discount'],
        //     ['url' => site_url('/welcome/log_out'), 'name' => 'Logout']
        // ];

        // Hierarchical Sitemap Structure
        $data['sitemap_links'] = [
            [
                'name' => 'Dashboard',
                'url' => site_url('/admin/dashboard'),
                'children' => []
            ],
            [
                'name' => 'Users',
                'url' => site_url('/admin/users'),
                'children' => []
            ],
            [
                'name' => 'Ads',
                'url' => site_url('/admin/ads'),
                'children' => []
            ],
            [
                'name' => 'Services',
                'url' => site_url('/admin/services'),
                'children' => []
            ],
            [
                'name' => 'Store',
                'url' => site_url('/admin/store'),
                'children' => []
            ],
            [
                'name' => 'Settings',
                'url' => '',
                'children' => [
                    ['name' => 'Help Center', 'url' => site_url('/admin/help')],
                    ['name' => 'Privacy Policy', 'url' => site_url('/admin/policy')],
                    ['name' => 'Push Notifications', 'url' => site_url('/admin/notification')],
                    ['name' => 'App Version', 'url' => site_url('/admin/versions')]
                ]
            ],
            [
                'name' => 'Rewards & Offers',
                'url' => '',
                'children' => [
                    ['name' => 'Spin Wheel', 'url' => site_url('/admin/SpinWheel')],
                    ['name' => 'Rewards', 'url' => site_url('/admin/rewards')],
                    ['name' => 'Discount', 'url' => site_url('/admin/discount')]
                ]
            ],
            [
                'name' => 'Logout',
                'url' => site_url('/welcome/log_out'),
                'children' => []
            ]
        ];


        // echo "<pre>";
        // print_r($data);
        // exit;

        $this->load->view('admin/includes/header', $data);
        $this->load->view('sitemap_view', $data);
        $this->load->view('admin/includes/footer');
    }
}
